import os


class Logger:
    def __init__(self, path, directory='log', quiet=False):
        if not os.path.exists(directory):
            os.mkdir(directory)
        self.file_path = os.path.join(directory, path)
        self.quiet = quiet

    def log(self, info):
        with open(self.file_path, 'a+', encoding='utf-8') as f:
            f.write(info + '\n')

    def print(self, info):
        if not self.quiet:
            print(info)
